%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Template for Leoben IoT Symposium 2025                %
% (c) David Neussl 2025                                 %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\ProvidesPackage{iotle}[2025-10-24 Class for submissions to the Leoben IoT Symposium]
\LoadClass[11pt,a4paper,ngerman,english,twocolumn,twoside]{article}
% Default package list
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[ngerman,english]{babel}
\usepackage[top=2cm,bottom=2cm,left=18mm,right=18mm,marginparwidth=1.75cm]{geometry}
\usepackage{amsmath}
\usepackage{graphicx}
\usepackage[hidelinks,breaklinks]{hyperref}
\usepackage{xparse}
\usepackage{multicol}
\usepackage{fancyhdr}
    \setlength{\headheight}{20pt}
\usepackage{lastpage}
\usepackage{enumitem}
    \setlist[itemize]{topsep=0pt, partopsep=0pt, parsep=0pt, itemsep=2pt}
    \setlist[enumerate]{topsep=0pt, partopsep=0pt, parsep=0pt, itemsep=2pt}
\usepackage{titlesec}
\usepackage{caption}

% Formatting of section titles
\titleformat{\section}[block]{\sffamily\bfseries\Large}{\thesection}{1em}{}
\titleformat{\subsection}[block]{\sffamily\bfseries\large}{\thesubsection}{1em}{}
\titleformat{\subsubsection}[block]{\sffamily\bfseries\normalsize}{\thesubsubsection}{1em}{}

% Set space around captions
\setlength{\abovecaptionskip}{5pt}  % Set space above the caption
\setlength{\belowcaptionskip}{5pt}  % Set space below the caption

% Captionsetup
\captionsetup{font=sf,
              font={small},
              labelfont={bf,footnotesize,sf},
              textfont={normalfont}}
\captionsetup[figure]{name=Fig.}
\captionsetup[table]{name=Tab.}


% Custom commands for title page
\newcommand{\leiot}[0]{Leoben IoT Sensor Systems Symposium 2025} % Name of Symposium
\newcommand{\leiotshort}[0]{IoT S3 2025} % Short name
\newcommand{\affil}[1]{\textsuperscript{#1}} % Affiliation indicator (superscript)
\newcommand{\affiliations}[2]{\def\@affiliations{#1}} % List of affiliations
\newcommand{\runningauthor}[1]{\def\@runningauthor{#1}} % Running author on all pages
\newcommand{\runningtitle}[1]{\def\@runningtitle{#1}} % Running title on all pages

% Custom page styles:
\fancypagestyle{iotletitle}{ % First page
    \fancyhead[R]{\sffamily\footnotesize\@runningauthor\,\@runningtitle\enskip|\enskip\thepage - \pageref{LastPage}}
    \fancyhead[L]{\sffamily\footnotesize\sffamily\leiotshort}
}
\fancypagestyle{iotlebody}{ % Rest of document
    \pagestyle{fancy}
    \fancyhf{}
    \fancyhead[RO]{\sffamily\footnotesize\@runningauthor\,\@runningtitle\enskip|\enskipthepage}
    \fancyhead[LO,RE]{\sffamily\footnotesize\leiotshort}
    \fancyhead[LE]{\sffamily\footnotesize\thepage\enskip|\enskip\@runningauthor\,\@runningtitle}
}
\pagestyle{iotlebody} % Set document page style

% Titlepage definition
\renewcommand{\maketitle}{%
    \thispagestyle{iotletitle}
    
    \twocolumn[{% Pack title page into one double column
    \centering
    % Title
    \Huge \textbf{\@title}
    \vspace{5mm}
    
    % Author Names
    \Large \@author
    \vspace{5mm}
    
    % Affiliations
    \footnotesize
    \@affiliations
    \vspace{5mm}
    
    % Conference Details
    \normalsize
    \textbf{\leiot} \\
    November 2025 \\
    Leoben, Austria
    \vspace{15mm}
    }]
}